/*------------------------
	+description+
	CCSGlobalResources.h

	This class is the central hub for resources in an application.
	Its purpose is to remove the inter-bundle dependancies by providing
	a common area for resources to be registered (by a name) and located.
	
	This class does not dictate what a 'resource' is, only that it is an
	object.  The class is simply a hash table of string keys with object
	values.
	
	An accessor off of NSApp has been provided (- globalResources) which
	returns the instance of this class in an application.
	
	Created By:	Craig White
				June 6, 1995

	-description-
	
	RCS Information
	=============
	$Log: MCGlobalResources.h,v $
	Revision 1.2  2002/04/28 21:52:28  alykhan
	Added method to load directory into global resources, added prefered... methods in anticipation of global preferences
	
	Revision 1.1  2001/09/23 09:51:24  alykhan
	Integrated Craig's stuff
	
	Revision 1.3  1999/03/25 01:57:51  cwhite
	Added some hooks for localization

	Revision 1.2  1998/01/09 05:51:52  cwhite
	Small changes for mach

	Revision 1.1  1998/01/09 03:03:59  cwhite
	Porting to OPENSTEP

 * Revision 1.1  1995/11/13  15:59:08  cwhite
 * Added the new classes
 *
 * Revision 1.1  1995/08/29  14:57:36  cwhite
 * Added subprojects to work area
 *
 * Revision 1.1  1995/06/09  19:10:58  cwhite
 * Added subprojects to work area
 *

*/


#import <Foundation/Foundation.h>

@interface MCGlobalResources:NSObject
{
    id				resourceTable;
    NSMutableArray		*delegates;
}

+ (id)defaultGlobalResources;

- (id)init;
- (void)registerResource:(id)aResource named:(NSString *)aName;
- (id)resourceNamed:(NSString *)aName;
- (void)addDelegate:(id)anObject;

// Checks the resource table for the resource aName, if it's not found, attempt to located it using NSBundle methods. Uses resourceNamed: and registerResource internally. If anObject is nil, the main bundle is used. This method located the resource, and loads into a string and registers the string
- (NSString *)loadAndRegisterStringResourceNamed:(NSString *)aName 
		ofType:(NSString *)aType inBundleOfObject:(id)anObject;

- (NSDictionary *)loadAndRegisterDictionaryResourceNamed:(NSString *)aName 
		ofType:(NSString *)aType inBundleOfObject:(id)anObject;

    
@end

@interface NSObject (GlobalResourcesDelegate)
- (id)globalResourceNotFound:(NSString *)aName;
@end

